/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.common.primitives.Ints;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.IFlexItem;
import dev.gigaherz.jsonthings.things.UseFinishMode;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.FoodBuilder;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParseException;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.StringValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import joptsimple.internal.Strings;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.UseAnim;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ItemParser
extends ThingParser<ItemBuilder> {
    public static final Logger LOGGER = LogManager.getLogger();

    public ItemParser(IEventBus bus) {
        super(GSON, "item");
        bus.addListener(this::register);
        bus.addListener(this::addToTabs);
    }

    public void register(RegisterEvent event) {
        event.register(Registries.f_256913_, helper -> {
            LOGGER.info("Started registering Item things, errors about unexpected registry domains are harmless...");
            ItemParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> helper.register(thing.getRegistryName(), (Object)((IFlexItem)thing.get()).self()), BaseBuilder::getRegistryName);
            LOGGER.info("Done processing thingpack Items.");
        });
    }

    public void addToTabs(BuildCreativeModeTabContentsEvent event) {
        this.getBuilders().forEach(thing -> thing.provideVariants((ResourceKey<CreativeModeTab>)event.getTabKey(), (CreativeModeTab.Output)event, event.getParameters(), (ItemBuilder)thing, false));
    }

    @Override
    public ItemBuilder processThing(ResourceLocation key, JsonObject data, Consumer<ItemBuilder> builderModification) {
        ItemBuilder builder = ItemBuilder.begin(this, key);
        JParse.begin(data).ifKey("parent", val -> val.string().map(ResourceLocation::new).handle(builder::setParent)).ifKey("type", val -> val.string().handle(builder::setType)).ifKey("max_stack_size", val -> val.intValue().range(1, 128).handle(builder::setMaxStackSize)).mutex(List.of("group", "creative_menu_stacks"), () -> new ThingParseException("Cannot have group and creative_menu_stacks at the same time.")).ifKey("group", val -> val.string().map(ResourceLocation::new).handle(builder::setGroup)).ifKey("creative_menu_stacks", val -> val.array().forEach((i, entry) -> entry.obj().raw(item -> builder.withCreativeMenuStack(this.parseStackContext((JsonObject)item, false, false), ItemParser.parseTabsList(item))))).ifKey("attribute_modifiers", val -> val.array().raw(arr -> this.parseAttributeModifiers((JsonArray)arr, builder))).ifKey("max_damage", val -> val.intValue().min(1).handle(builder::setMaxDamage)).ifKey("fire_resistant", val -> val.bool().handle(builder::setFireResistant)).ifKey("food", val -> val.ifString(str -> str.map(ResourceLocation::new).handle(builder::setFood)).ifObj(obj -> obj.raw(food -> {
            try {
                FoodBuilder foodBuilder = (FoodBuilder)JsonThings.foodParser.parseFromElement(builder.getRegistryName(), (JsonElement)food);
                if (foodBuilder != null) {
                    builder.setFood((FoodProperties)foodBuilder.get());
                }
            }
            catch (Exception e) {
                throw new ThingParseException("Exception while parsing nested food in " + builder.getRegistryName(), e);
            }
        })).typeError()).ifKey("container", val -> val.string().map(ResourceLocation::new).handle(builder::setContainerItem)).ifKey("delayed_use", val -> val.obj().key("duration", val1 -> val1.intValue().handle(builder::setUseTime)).key("animation", val1 -> val1.string().map(str -> UseAnim.valueOf((String)str.toUpperCase())).handle(builder::setUseAnim)).ifKey("on_complete", val1 -> val1.string().map(str -> UseFinishMode.valueOf(str.toUpperCase())).handle(builder::setUseFinishMode))).ifKey("color_handler", val -> val.string().handle(builder::setColorHandler)).ifKey("lore", val -> val.array().unwrapRaw(this::parseLore).handle(builder::setLore)).ifKey("tool_actions", val -> val.array().strings().flatten(StringValue::getAsString, String[]::new).handle(builder::setToolActions)).ifKey("events", val -> val.obj().map(this::parseEvents).handle(builder::setEventMap)).ifKey("burn_duration", val -> val.intValue().min(1).handle(builder::setBurnDuration));
        builderModification.accept(builder);
        builder.setFactory(builder.getType().getFactory(data));
        return builder;
    }

    private List<MutableComponent> parseLore(JsonArray lines) {
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        for (JsonElement e : lines) {
            lore.add(Component.Serializer.m_130691_((JsonElement)e));
        }
        return lore;
    }

    private void parseAttributeModifiers(JsonArray list, ItemBuilder builder) {
        for (JsonElement e : list) {
            int operation;
            String name;
            String loc;
            String name2;
            JsonObject item = e.getAsJsonObject();
            if (item.has("slot")) {
                name2 = item.get("slot").getAsString();
                List<String> names = Arrays.stream(EquipmentSlot.values()).map(EquipmentSlot::m_20751_).toList();
                if (Strings.isNullOrEmpty((String)name2) || !names.contains(name2)) {
                    throw new ThingParseException("Attribute modifier slot must be a valid equipment slot name: " + String.join((CharSequence)", ", names));
                }
            } else {
                throw new ThingParseException("Attribute modifier slot must be a non-empty string.");
            }
            EquipmentSlot slot = EquipmentSlot.m_20747_((String)name2);
            if (item.has("attribute")) {
                loc = item.get("attribute").getAsString();
                if (Strings.isNullOrEmpty((String)loc)) {
                    throw new ThingParseException("Attribute must be present and a valid resource location.");
                }
            } else {
                throw new ThingParseException("Attribute must be present and a valid resource location.");
            }
            ResourceLocation attribute = new ResourceLocation(loc);
            UUID uuid = null;
            if (item.has("uuid")) {
                String uuidString = item.get("uuid").getAsString();
                if (!Strings.isNullOrEmpty((String)uuidString)) {
                    uuid = UUID.fromString(uuidString);
                } else {
                    throw new ThingParseException("If present, uuid must be an UUID-formatted string.");
                }
            }
            if (item.has("name")) {
                name = item.get("name").getAsString();
                if (Strings.isNullOrEmpty((String)name)) {
                    throw new ThingParseException("Attribute modifier name must be a non-empty string.");
                }
            } else {
                throw new ThingParseException("Attribute modifier name must be a non-empty string.");
            }
            if (!item.has("amount")) {
                throw new ThingParseException("Attribute modifier amount must be a floating point number.");
            }
            double amount = item.get("amount").getAsDouble();
            if (item.has("operation")) {
                String opName = item.get("operation").getAsString();
                Integer opInt = Ints.tryParse((String)opName);
                operation = opInt == null ? AttributeModifier.Operation.valueOf((String)opName.toUpperCase()).m_22235_() : opInt.intValue();
            } else {
                throw new ThingParseException("Attribute modifier amount must have an operation type.");
            }
            builder.withAttributeModifier(slot, attribute, uuid, name, amount, operation);
        }
    }

    public static ResourceLocation[] parseTabsList(JsonObject stackEntry) {
        if (stackEntry.has("tabs")) {
            JsonArray tabs = stackEntry.get("tabs").getAsJsonArray();
            ResourceLocation[] tabsArray = new ResourceLocation[tabs.size()];
            int tabIndex = 0;
            for (JsonElement e : tabs) {
                String str = e.getAsString();
                if (!Strings.isNullOrEmpty((String)str)) {
                    tabsArray[tabIndex++] = new ResourceLocation(str);
                    continue;
                }
                throw new ThingParseException("Tabs array must contain non-empty strings.");
            }
            return tabsArray;
        }
        throw new ThingParseException("Creative menu entry must contain a list of tabs.");
    }
}

